<?php
require_once("../config.php");

$email = $_POST['email'] ?? '';
$password = $_POST['password'] ?? '';

if ($email=='' || $password=='') {
  json_out(["status"=>false, "message"=>"Email & password wajib diisi"]);
}

$stmt = $conn->prepare("SELECT id,name,email,password FROM users WHERE email=? LIMIT 1");
$stmt->bind_param("s", $email);
$stmt->execute();
$res = $stmt->get_result();

if ($res->num_rows == 0) {
  json_out(["status"=>false, "message"=>"User tidak ditemukan"]);
}

$user = $res->fetch_assoc();
if (!password_verify($password, $user['password'])) {
  json_out(["status"=>false, "message"=>"Password salah"]);
}

json_out([
  "status"=>true,
  "message"=>"Login berhasil",
  "data"=>[
    "id"=>$user["id"],
    "name"=>$user["name"],
    "email"=>$user["email"]
  ]
]);
